/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import java.util.Collection;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public class PrimaryKey<T extends Table<T>, ID>
implements Key<T, ID> {
    private final T table;
    private final KeepOrderSet<Column<T, ?>> columns = new KeepOrderSet();

    public PrimaryKey(Collection<Column<T, Object>> columns) {
        this.table = ((Column)Iterables.first(columns)).getTable();
        this.columns.addAll(columns);
    }

    public PrimaryKey(Column<T, Object> column, Column<T, Object> ... additionalColumns) {
        this.table = column.getTable();
        this.addColumns(column, additionalColumns);
    }

    @Override
    public T getTable() {
        return this.table;
    }

    public void addColumns(Column<T, Object> column, Column<T, Object> ... additionalColumns) {
        this.addColumn(column);
        for (Column<T, Object> additionalColumn : additionalColumns) {
            this.addColumn(additionalColumn);
        }
    }

    public <O> void addColumn(Column<T, O> column) {
        this.columns.add(column);
    }

    @Override
    public KeepOrderSet<Column<T, ?>> getColumns() {
        return new KeepOrderSet(this.columns);
    }

    @Override
    public boolean isComposed() {
        return this.columns.size() > 1;
    }
}

